/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.shells.control;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.nooj4nlp.controller.DictionaryEditorShell.DictionaryEditorShellController;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class DictionaryCommandInternalFrameListener
implements InternalFrameListener {
    private JMenuBar menuBar;
    private DictionaryEditorShellController controller;

    public DictionaryCommandInternalFrameListener(DictionaryEditorShellController conroller) {
        this.controller = conroller;
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        this.menuBar = Launcher.getMenuBar();
        this.controller.getShell().getMnDictionary().setVisible(true);
        this.menuBar.add(this.controller.getShell().getMnDictionary());
        Launcher.mnEdit.setVisible(true);
        boolean b = false;
        int n = Launcher.mnWindows.getItemCount();
        String basename = FilenameUtils.getBaseName(this.controller.getFullName()) + ".dic";
        for (int i = 0; i < n; ++i) {
            if (Launcher.mnWindows.getItem(i) == null) continue;
            String aux = Launcher.mnWindows.getItem(i).getText();
            if (aux.equals(basename)) {
                Launcher.mnWindows.getItem(i).setSelected(true);
                b = true;
                continue;
            }
            Launcher.mnWindows.getItem(i).setSelected(false);
        }
        if (!b) {
            JCheckBoxMenuItem checkmenu = new JCheckBoxMenuItem(basename);
            checkmenu.setSelected(true);
            Launcher.mnWindows.add(checkmenu);
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.controller.isModified() && !Launcher.projectMode) {
            int answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Save dictionary file?", "NooJ: dictionary file has not been saved", 0);
            if (answer == 0) {
                try {
                    CursorChangeEffect.setCustomCursor(3);
                    this.controller.saveDictionary();
                    this.controller.close();
                }
                finally {
                    CursorChangeEffect.setCustomCursor(0);
                }
            } else {
                this.controller.close();
            }
        } else {
            this.controller.close();
        }
        String basename = FilenameUtils.getBaseName(this.controller.getFullName()) + ".dic";
        int n = Launcher.mnWindows.getItemCount();
        for (int i = 0; i < n; ++i) {
            String aux;
            if (Launcher.mnWindows.getItem(i) == null || !(aux = Launcher.mnWindows.getItem(i).getText()).equals(basename)) continue;
            Launcher.mnWindows.remove(i);
        }
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        this.controller.getShell().getMnDictionary().setVisible(false);
        this.menuBar.repaint();
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }
}

